#!/bin/bash

set -e

function usage()
{
	echo -ne "Usage: sudo $0 <ota upgrade package> | <switch-slot>\n"
	echo -ne "\t<ota upgrade package>: \n"
	echo -ne "\t   the pathname of the ota upgrade package (.../upgrade.tar.gz)\n"
	echo -ne "Example:\n"
	echo -ne "\tsudo $0 /aaa/bbb/upgrade.tar.gz\n"
	exit 1
}

USERID=$(id -u)
OTA_CMD="/usr/bin/updateEngine"
if [ "${USERID}" -ne 0 ]; then
       echo "ERROR: please run this program as root."
       exit 0
fi
if [ $# -lt 1 ]; then
	usage
fi
NARGS=$#
OTA_PKG=$1
if [[ ${OTA_PKG} =~ tar ]]; then
	if [ ! -f ${OTA_PKG} ]; then
		echo "ERROR: upgrade file '${OTA_PKG}' does not exist!"
		usage
	fi
else	
	usage
fi

export OTA_TOOLS_WORK_DIR="/opt/xgrids"
if [ $# -gt 1 ]; then
	export OTA_WORK_DIR=$2
else
	export OTA_WORK_DIR="/mnt/data/ota_work"
fi

OTA_TOOL_DIR=$(dirname  ${OTA_PKG})
if [ -f ${OTA_TOOL_DIR}/ota_start.sh ]; then
	export OTA_SCRIPT_DIR=${OTA_TOOL_DIR}
else
	export OTA_SCRIPT_DIR="${OTA_TOOLS_WORK_DIR}/system/scripts/upgrade"
fi

source ${OTA_SCRIPT_DIR}/ota_log.sh
source ${OTA_SCRIPT_DIR}/ota_common.func
ota_log_dir="/var/log/ota_log"
ota_log "init_ota_log ${ota_log_dir}"
if ! init_ota_log "${ota_log_dir}"; then
	ota_log "ERROR: failed to run \"init_ota_log ${ota_log_dir}\""
fi
ota_log "Command: '${OTA_SCRIPT_DIR}/do_ota_prepare.sh ${OTA_PKG}'"
source ${OTA_SCRIPT_DIR}/do_ota_prepare.sh "${OTA_PKG}"

if [ ${NARGS} -lt 3 ]; then
	ota_log "Command: '${OTA_SCRIPT_DIR}/do_ota_processing.sh ${OTA_PKG}'"
	source ${OTA_SCRIPT_DIR}/do_ota_processing.sh "${OTA_PKG}"
else
	ota_log "Command:'none', args:'$@'"
fi


