import time 
import datetime 
import os,sys
import requests
import json
import operator  

ip_default = '192.168.1.201'
upgrade_file = sys.argv[1]
timeout = None
retry_num_default = 5
class HttpApi(object):
 
    def _send_get_request_and_receive_return_info(self,url,timeout=10, *, retry_num=retry_num_default):

        s = requests.Session()
        a = requests.adapters.HTTPAdapter(max_retries=retry_num)
        s.mount('http://', a)
        res = s.request('GET', url, timeout = timeout)
        assert res.status_code == 200, 'cannot connect to lidar, error code: %s' %(res.status_code)
        info =  json.loads(res.text)
        info['Connection_Status'] = res.status_code
        return info

    def _send_post_request_and_receive_return_info(self, url, timeout=10, *, retry_num=retry_num_default, data=None, files=None):
  
        s = requests.Session()
        a = requests.adapters.HTTPAdapter(max_retries=retry_num)
        s.mount('http://', a)
        res = s.request('POST', url, data=data, files=files,timeout=timeout)
        assert res.status_code == 200, 'cannot connect to lidar, error code: %s' %(res.status_code)
        info =  json.loads(res.text)
        info['Connection_Status'] = res.status_code
          
        return info

    def upgrade_LiDAR(self,IP=ip_default,file = upgrade_file,timeout=10):
        
        url = 'http://%s/upgrade.cgi'\
        %(IP)
        
        files = {'file':open(file,'rb')}
        s = requests.Session()
        retry_num = 3
        a = requests.adapters.HTTPAdapter(max_retries=retry_num)
        s.mount('http://',a)
        res = s.request('POST', url, files=files, timeout = timeout)
        assert res.status_code == 200, 'cannot connect to lidar, error code: %s' %(res.status_code)
        info =  json.loads(res.text)
        info['Connection_Status'] = res.status_code
        # print(info)
        return info

    def http_get_motor_version(self, IP=ip_default, timeout=10):
        url = 'http://%s/pandar.cgi?action=get&object=motor_version'\
        %(IP)

        return self._send_get_request_and_receive_return_info(url,timeout)['Body']['motor_version']

    def http_get_work_mode(self, IP=ip_default, timeout=10):

        url = 'http://%s/pandar.cgi?action=get&object=workmode'\
        %(IP)

        return self._send_get_request_and_receive_return_info(url,timeout)

    def http_set_lidar_reboot(self, IP=ip_default, timeout=10):

        url = 'http://%s/pandar.cgi?action=set&object=reboot'\
        %(IP)

        return self._send_get_request_and_receive_return_info(url,timeout)



    def check_upgrade_status_and_reboot(self, IP=ip_default, timeout=10):

        while True:
            json_data = self.http_get_work_mode()
            # print(json_data)

            all_statuses_completed = all(item['Status'] == 2 for item in json_data['Body']['UpdateStatus'])

            if all_statuses_completed:
                self.http_set_lidar_reboot()
                print("Upgrade completed, lidar restarted!!!")
                return

            time.sleep(3)  



if __name__ =='__main__':
    y=HttpApi()
    motor_ver = y.http_get_motor_version()
    print(motor_ver)
    if motor_ver[:2] == "XT":
        if motor_ver[:12] == "XT_MT_V1.5.1" : # 后续若有允许升级的电机版本号可以在这里添加 如：if motor_ver[:12] == "XT_MT_V1.5.1" or motor_ver[:12] == "XT_MT_V1.5.2":
            print("Will upgrade...")
            print(y.upgrade_LiDAR())
            print("Start Upgrade...")
            print("Please keep the power on while upgrading. The device will automatically reboot after the upgrade.")
            time.sleep(5)
            y.check_upgrade_status_and_reboot()
        else:
            print("Upgrade not allowed！！！")

    else:
        print("Motor version acquisition failed, please execute again")