#!/bin/bash

# This is a script use to update OTA_SCRIPT_DIR
set -e

source ${OTA_SCRIPT_DIR}/ota_log.sh
source ${OTA_SCRIPT_DIR}/ota_common.func
ota_log "Enter '${OTA_SCRIPT_DIR}/do_ota_prepare.sh'"

function switch_ota_tool()
{
    local targe_file="${1}"
    local target_dir="/home/xgrids/upgrade"
    local pkg_type="tool"
    # Extract the OTA upgrade package into OTA work directory
    if [ -f "${targe_file}" ]; then
        ota_log "Extract ${targe_file} to ${OTA_WORK_DIR}..."
        # Create OTA work directory
        if [ -d "${OTA_WORK_DIR}" ]; then
            rm -rf "${OTA_WORK_DIR}"
        fi
        mkdir -p ${OTA_WORK_DIR}
        chmod a+w "${OTA_WORK_DIR}"
        if ! tar xzvf "${targe_file}" -C "${OTA_WORK_DIR}" >/dev/null 2>&1; then
            ota_log " ERROR: failed to run \"tar xzvf ${targe_file} -C ${OTA_WORK_DIR}\""
            exit 1
        fi
    else
        ota_log "ERROR: '${targe_file}' does not exist!"
        exit 1
    fi

    ota_log "Parse ota tools info..."
    local cfg_file=`basename ${targe_file}`
    cfg_file="${OTA_WORK_DIR}/${cfg_file%%.*}"
    cfg_file="${cfg_file}/upgrade.json"

    local cfg_ota_work_dir=`python3 ${OTA_SCRIPT_DIR}/version.py -t ota -m head -g commpath -f ${cfg_file}`
    local catry_type_list=`python3 ${OTA_SCRIPT_DIR}/version.py -t ota -m content -g "${pkg_type}" -f ${cfg_file}`
    ota_log " type list:${catry_type_list}"
    ota_log " pkg_type:${pkg_type}"
    for catry_type in ${catry_type_list}; do
        local tool_name=`python2 ${OTA_SCRIPT_DIR}/version.py -t ota -m content -g "${pkg_type}" "${catry_type}" "name" -f ${cfg_file}`
        local tool_category=`python2 ${OTA_SCRIPT_DIR}/version.py -t ota -m content -g "${pkg_type}" "${catry_type}" "category" -f ${cfg_file}`
        local tool_subpath=`python2 ${OTA_SCRIPT_DIR}/version.py -t ota -m content -g "${pkg_type}" "${catry_type}" "subpath" -f ${cfg_file}`
        local tool_filename=`python2 ${OTA_SCRIPT_DIR}/version.py -t ota -m content -g "${pkg_type}" "${catry_type}" "filename" -f ${cfg_file}`
        local tool_version=`python2 ${OTA_SCRIPT_DIR}/version.py -t ota -m content -g "${pkg_type}" "${catry_type}" "version" -f ${cfg_file}`
        local tool_datetime=`python2 ${OTA_SCRIPT_DIR}/version.py -t ota -m content -g "${pkg_type}" "${catry_type}" "datetime" -f ${cfg_file}`
        local tool_md5sum=`python2 ${OTA_SCRIPT_DIR}/version.py -t ota -m content -g "${pkg_type}" "${catry_type}" "md5sum" -f ${cfg_file}`
        targe_file="${OTA_WORK_DIR}/${tool_subpath}/${tool_filename}"
        ota_log " ${tool_name}:"
        ota_log " ${pkg_type}.category:${tool_category}"
        ota_log " ${pkg_type}.subpath:${tool_subpath}"
        ota_log " ${pkg_type}.filename:${tool_filename}"
        ota_log " ${pkg_type}.version:${tool_version}"
        ota_log " ${pkg_type}.datetime:${tool_datetime}"
        ota_log " ${pkg_type}.md5sum:${tool_md5sum}"
        if [ -n "${tool_md5sum}" ] && [ -f "${targe_file}" ]; then
            local md5ck_calc=`md5sum ${targe_file}`
            md5ck_calc=`echo ${md5ck_calc} | awk -F ' ' '{print $1}'`
            if [ "${tool_md5sum}" != "${md5ck_calc}" ]; then
                ota_log " ERROR: ${tool_subpath}/${tool_filename} md5sum does not match!(target:${tool_md5sum},calc:${md5ck_calc})"
                exit 1
            fi
            ota_log " ${tool_subpath}/${tool_filename} md5sum matched."
        fi
        if [ -f "${targe_file}" ] ; then
            ota_log "Extract ota tools to '${target_dir}'..."
            if [ -d ${target_dir} ]; then
                rm -rf ${target_dir}
            fi
            mkdir -p ${target_dir}
            chmod a+w "${target_dir}"
            tar zxvf ${targe_file} -C ${target_dir} 
            if [ $? -ne 0 ] ; then
                ota_log " ERROR: tar extract ${targe_file} failed!"
                exit 1
            fi   
            ota_log " old ota tools path.'${OTA_SCRIPT_DIR}'"
            ota_log " new ota tools path.'${target_dir}'"
            mkdir -p ${cfg_ota_work_dir}
            chmod a+w "${cfg_ota_work_dir}"
            export OTA_WORK_DIR="${cfg_ota_work_dir}"
            export OTA_TOOLS_WORK_DIR="${target_dir}"
            export OTA_SCRIPT_DIR="${OTA_TOOLS_WORK_DIR}"
            if [ -f ${target_dir}/updateEngine ]; then
                cp -f ${target_dir}/updateEngine /usr/bin/
            fi
            if [ -f ${target_dir}/recovery ]; then
                cp -f ${target_dir}/recovery /usr/bin/
            fi
            return 0
        else
            ota_log " ERROR: '${targe_file}' does not exist!"
            exit 1
        fi
    done
    ota_log " ota tools path unchang."
}

nargs=$#
if [ ! -f ${!nargs} ] ; then
    ota_log " ERROR: tar package '${!nargs}' does not exist!"
    exit 1
fi   

switch_ota_tool "${!nargs}"


