#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Time    : 2022/06/27 10:47
# @Author  : Garrett
# @Email   : gang.pan@xgrids.com
# @File    : version.py

import os, sys, getopt
import json
from optparse import OptionParser
from optparse import OptionGroup

fwheadinfo = """
{
    "version":"",
    "producttype":"",
    "buildtime":"",
    "packages":[
    ]
}
"""
fwpackageinfo = """
{
    "name":"",
    "filename":"",
    "version":"",
    "datetime":"",
    "md5sum":""
}
"""

otaheadinfo = """
{
    "commversion":"",
    "producttype":"",
    "commpath":"",
    "activelist":"",
    "supportlist":"",
    "packages":[
    ]
}
"""
otapackageinfo = """
{
    "name":"",
    "category":"",
    "subpath":"",
    "filename":"",
    "version":"",
    "datetime":"",
    "md5sum":""
}
"""

devverinfo = """
{
    "name":"",
    "version":"",
    "producttype":"",
    "dateTime":""
}
"""

class fwversion:  
    def __init__(self, ver, prod, bt):    
        self.version = ver    
        self.producttype = prod 
        self.buildtime = bt    
        
def get_fw_head_info(json_data):
    ver = json_data["version"]
    prod = json_data["producttype"]
    bt = json_data["buildtime"]
    data = fwversion(ver, prod, bt)
    json_data = json.dumps(data.__dict__)
    print(json_data)
    return json_data

def get_fw_head_val_by_key(json_data, key):
    if (key in json_data) :
        print(json_data[key])
        return  json_data[key]

def set_fw_head_info(json_data, ver, prod, path):
    json_data["version"] = ver
    json_data["producttype"] = prod
    json_data["buildtime"] = path
    return json_data

def get_fw_content_info(json_data, name):
    for item in json_data:
        if item == "packages":
            subVerList = json_data[item]
            subVerNum = 0
            for subVer in subVerList:
                subVerNum += 1
                for subVerKey in subVer:
                    if subVer[subVerKey] == name:
                        return  json_data["packages"][subVerNum - 1]

def set_fw_content_info(json_data, name, ver, time, file, md5):
    for item in json_data:
        if item == "packages":
            subVerList = json_data[item]
            subVerNum = 0
            for subVer in subVerList:
                subVerNum += 1
                for subVerKey in subVer:
                    if subVer[subVerKey] == name:
                        json_data["packages"][subVerNum - 1]["version"] = ver
                        json_data["packages"][subVerNum - 1]["datetime"] = time
                        json_data["packages"][subVerNum - 1]["filename"] = file
                        json_data["packages"][subVerNum - 1]["md5sum"] = md5
                        return  json_data["packages"][subVerNum - 1]

def get_fw_content_val_by_key(json_data, name, key):
    for item in json_data:
        if item == "packages":
            subVerList = json_data[item]
            subVerNum = 0
            for subVer in subVerList:
                subVerNum += 1
                for subVerKey in subVer:
                    if subVer[subVerKey] == name:
                        if (key in subVer) :
                            print(json_data["packages"][subVerNum - 1][key])
                            return  json_data["packages"][subVerNum - 1][key]
   
def set_fw_content_val_by_key(json_data, name, key, value):
    for item in json_data:
        if item == "packages":
            subVerList = json_data[item]
            subVerNum = 0
            for subVer in subVerList:
                subVerNum += 1
                for subVerKey in subVer:
                    if subVer[subVerKey] == name:
                        if (key in subVer) :
                            json_data["packages"][subVerNum - 1][key] = value
                            return  json_data
   
def insert_fw_content_info(json_data, name, file, ver, time, md5):
    for item in json_data:
        if item == "packages":
            pkg_data = load_json_strings(fwpackageinfo)
            pkg_data["name"] = name
            pkg_data["filename"] = file
            pkg_data["version"] = ver  
            pkg_data["datetime"] = time
            pkg_data["md5sum"] = md5
            json_data[item].append(pkg_data)
            # print( pkg_data)
            # print( json_data)
            return  json_data

class otaversion:  
    def __init__(self, ver, prod, active, support):    
        self.commversion = ver    
        self.producttype = prod    
        self.commpath = path    
        self.activelist = active    
        self.supportlist = support    

def get_ota_head_info(json_data):
    ver = json_data["commversion"]
    prod = json_data["producttype"]
    path = json_data["commpath"]
    active = json_data["activelist"]
    support = json_data["supportlist"]
    data = otaversion(ver, prod, path, active, support)
    json_data = json.dumps(data.__dict__)
    print(json_data)
    return json_data

def get_ota_head_val_by_key(json_data, key):
    if (key in json_data) :
        print(json_data[key])
        return  json_data[key]

def set_ota_head_info(json_data, ver, prod, path,active,support):
    json_data["commversion"] = ver
    json_data["producttype"] = prod
    json_data["commpath"] = path
    json_data["activelist"] = active
    json_data["supportlist"] = support
    return json_data
             
def get_ota_content_info(json_data, name, catry):
    for item in json_data:
        if item == "packages":
            subVerList = json_data[item]
            subVerNum = 0
            for subVer in subVerList:
                subVerNum += 1
                matchCnt = 0
                for subVerKey in subVer:
                    if subVer[subVerKey] == name:
                        matchCnt += 1
                    if subVer[subVerKey] == catry:
                        matchCnt += 1
                    if matchCnt == 2:
                        matchCnt = 0
                        return  json_data["packages"][subVerNum - 1]

def set_ota_content_info(json_data, name, catry, ver, time, file, md5):
    for item in json_data:
        if item == "packages":
            subVerList = json_data[item]
            subVerNum = 0
            for subVer in subVerList:
                subVerNum += 1
                for subVerKey in subVer:
                    if subVer[subVerKey] == name:
                        if subVer[subVerKey] == catry:
                            json_data["packages"][subVerNum - 1]["version"] = ver
                            json_data["packages"][subVerNum - 1]["datetime"] = time
                            json_data["packages"][subVerNum - 1]["filename"] = file
                            json_data["packages"][subVerNum - 1]["md5sum"] = md5
                            return  json_data["packages"][subVerNum - 1]

def get_ota_content_val_by_key(json_data, name, catry, key):
    for item in json_data:
        if item == "packages":
            subVerList = json_data[item]
            subVerNum = 0
            for subVer in subVerList:
                subVerNum += 1
                matchCnt = 0
                for subVerKey in subVer:
                    if subVer[subVerKey] == name:
                        matchCnt += 1
                    if subVer[subVerKey] == catry:
                        matchCnt += 1
                    if matchCnt == 2:
                        matchCnt = 0
                        if (key in subVer) :
                            print(json_data["packages"][subVerNum - 1][key])
                            return  json_data["packages"][subVerNum - 1][key]
   
def get_ota_content_catry_by_name(json_data, name,):
    for item in json_data:
        if item == "packages":
            categoryText=""
            subVerList = json_data[item]
            subVerNum = 0
            for subVer in subVerList:
                subVerNum += 1
                matchCnt = 0
                for subVerKey in subVer:
                    if subVer[subVerKey] == name:
                        categoryText += subVer["category"] + " "
            print(categoryText)
            return  categoryText

def set_ota_content_val_by_key(json_data, name, catry, key, value):
    for item in json_data:
        if item == "packages":
            subVerList = json_data[item]
            subVerNum = 0
            for subVer in subVerList:
                subVerNum += 1
                matchCnt = 0
                for subVerKey in subVer:
                    if subVer[subVerKey] == name:
                        matchCnt += 1
                    if subVer[subVerKey] == catry:
                        matchCnt += 1
                    if matchCnt == 2:
                        matchCnt = 0
                        if (key in subVer) :
                            json_data["packages"][subVerNum - 1][key] = value
                            return  json_data

def insert_ota_content_info(json_data, name, catry, path, file, ver, time, md5):
    for item in json_data:
        if item == "packages":
            pkg_data = load_json_strings(otapackageinfo)
            pkg_data["name"] = name
            pkg_data["category"] = catry
            pkg_data["subpath"] = path
            pkg_data["filename"] = file
            pkg_data["version"] = ver  
            pkg_data["datetime"] = time
            pkg_data["md5sum"] = md5
            json_data[item].append(pkg_data)
            # print( pkg_data)
            # print( json_data)
            return  json_data

def insert_dev_ver_info(json_data, name, ver, prod, time):
    json_data["name"] = name
    json_data["version"] = ver
    json_data["producttype"] = prod
    json_data["dateTime"] = time
    return json_data

def load_json_file(filename):
    with open(filename, 'rb') as f:
            json_data = json.load(f)
    return json_data

def load_json_strings(strings):
    json_data = json.loads(strings)
    return json_data

def rewrite_json_file(json_data, filename):
    with open(filename, 'w', encoding='utf-8') as f:
        json.dump(json_data, f, ensure_ascii=False, indent=4)
    f.close()

def option_cb(option, opt_str, value, parser, *args): 
   print("option = %s, opt_str = %s,  value = %s" % (option, opt_str, value))
   print("parser.values = %s, parser.rargs = %s" % (parser.values, parser.rargs))

def parserOptions(argv):
    parser = OptionParser(usage="usage: %prog <options> <item> [args] <filename>",version="%prog 1.0",description="version OptionParser!")
    parser.add_option("-g", "--get", action="store_true",
            dest="get",
            default=False,
            help="get package info from version file")
    parser.add_option("-s", "--set", action="store_true",
            dest="set",
            default=False,
            help="set package info to version file")
    parser.add_option("-i", "--insert", action="store_true",
            dest="insert",
            default=False,
            help="insert ota package info to version file")
    parser.add_option("-l", "--list", action="callback",
            callback=option_cb,
            callback_args=(), 
            #callback_args=(options, args), 
            callback_kwargs={}, 
            nargs=2, 
            default=None, 
            metavar="FUNC",
            help="option callback")
    group = OptionGroup(parser, "apend args")
    group.add_option("-t", "--type", action="store",
            dest="type",
            metavar='type',
            default="fw",
            help="version info type of fw or ota")
    group.add_option("-m", "--format", action="store",
            dest="format",
            metavar='format',
            default="fw",
            help="version info format of fw or ota")
    group.add_option("-f", "--file", action="store",
            dest="filename",
            metavar='filename',
            help="read package info from  version file")
    parser.add_option_group(group)

    (options, args) = parser.parse_args(argv)
    return (options, args)


def processOptions(opts, args):
    #print("*" * 160)
    #print('options: ', options)
    #print('args: ', args)
    #print("*" * 160)
    if opts.get:
            data = load_json_file(opts.filename)
            if opts.format == "head":
                    if opts.type == "fw":
                            if len(args)  == 1:
                                    # e.g.  sudo python3 version.py -t fw -m head -g version -f  Version.json
                                    get_fw_head_val_by_key(data, args[0])
                            else:
                                    # e.g.  sudo python3 version.py -t fw -m head -g -f Version.json
                                    get_fw_head_info(data)
                    elif opts.type == "ota":
                            if len(args)  == 1:
                                    # e.g.  sudo python3 version.py -t ota -m head -g  commversion -f upgrade.json
                                    get_ota_head_val_by_key(data, args[0])
                            else:
                                    # e.g.  sudo python3 version.py -t ota -m head -g -f upgrade.json
                                    get_ota_head_info(data)
            elif opts.format == "content":
                    if opts.type == "fw":
                            if len(args)  == 1:
                                    # e.g.  sudo python3 version.py -t ota -m content -g "SYS" -f Version.json
                                    get_fw_content_info(data, args[0])
                            if len(args)  == 2:
                                    # e.g.  sudo python3 version.py -t ota -m content -g "SYS" "filename" -f Version.json
                                    get_fw_content_val_by_key(data, args[0], args[1])                                    
                    elif opts.type == "ota":
                            if len(args)  == 1:
                                    # e.g.  sudo python3 version.py -t ota -m content -g "mcu" -f upgrade.json
                                    get_ota_content_catry_by_name(data, args[0])
                            if len(args)  == 2:
                                    # e.g.  sudo python3 version.py -t ota -m content -g "mcu"  "lixel_v2" -f upgrade.json
                                    get_ota_content_info(data, args[0], args[1])
                            if len(args)  == 3:
                                    # e.g.  sudo python3 version.py -t ota -m content -g "mcu" "lixel_v2"  "filename" -f upgrade.json
                                    get_ota_content_val_by_key(data, args[0], args[1], args[2])                                    
    elif opts.set:
            data = load_json_file(opts.filename)
            if opts.format == "head":
                    if opts.type == "fw":
                            if len(args)  == 3:
                                     # e.g.  sudo python3 version.py -t fw -m head -s "V0.1.4" "LIXEL_K1" "20230506"  -f  Version.json
                                    set_fw_head_info(data, args[0], args[1], args[2])
                                    rewrite_json_file(data, opts.filename)            
                    elif opts.type == "ota":
                            if len(args)  == 5 :
                                     # e.g.  sudo python3 version.py -t ota -m head -s "V0.1.4"  "LIXEL_K1" "/mnt/data/"  "app,mcu,..."  "app,mcu,..." -f upgrade.json
                                    set_ota_head_info(data, args[0], args[1], args[2], args[3], args[4])
                                    rewrite_json_file(data, opts.filename)            
            elif opts.format == "content":
                if opts.type == "fw":
                    if len(args)  == 3:
                         # e.g.  sudo python3 version.py -t fw -m "content"  -s "MCU" "md5sum"  "56e3a7f4db73e340a784c9fb863596ae" -f Version.json
                        set_fw_content_val_by_key(data, args[0], args[1], args[2])
                        rewrite_json_file(data, opts.filename)
                    if len(args)  == 5:
                         # e.g.  sudo python3 version.py -t fw -m "content"  -s "MCU" "V0.1.3"  "20230506" "LIXEL-MCU-V0.1.3/mcu_v00.01.03.062222_alpha.hex" "56e3a7f4db73e340a784c9fb863596ae" -f Version.json
                        set_fw_content_info(data, args[0], args[1], args[2], args[3], args[4])
                        rewrite_json_file(data, opts.filename)
                elif opts.type == "ota":
                    if len(args)  == 4:
                     # e.g.  sudo python3 version.py  -t ota -m "content" -s  "mcu" "lixell_v1" "md5sum" "56e3a7f4db73e340a784c9fb863596ae"  -f upgrade.json
                        set_ota_content_val_by_key(data, args[0], args[1], args[2], args[3])
                        rewrite_json_file(data, opts.filename)            
                    if len(args)  == 6:
                     # e.g.  sudo python3 version.py  -t ota -m "content" -s  "mcu" "lixell_v1" "V1.1.6-mcu" "20230506"  "LIXEL_APP_V1.1.6_20230506.bin" "56e3a7f4db73e340a784c9fb863596ae"  -f upgrade.json
                        set_ota_content_info(data, args[0], args[1], args[2], args[3], args[4], args[5])
                        rewrite_json_file(data, opts.filename)     
    elif opts.insert:     
            if opts.type == "fw":
                    if os.path.exists(opts.filename):
                            data = load_json_file(opts.filename)
                    else:
                            data = load_json_strings(fwheadinfo)
                    if len(args)  == 5:
                             # e.g.  sudo python3 version.py -t fw -i "mcu" "LIXEL_APP_V1.1.6_20230506.bin" "V1.1.6-mcu" "20230506" "56e3a7f4db73e340a784c9fb863596ae" -f Version.json
                            insert_fw_content_info(data, args[0], args[1], args[2], args[3], args[4])
                            rewrite_json_file(data, opts.filename)
            elif opts.type == "ota":
                    if os.path.exists(opts.filename):
                            data = load_json_file(opts.filename)
                    else:
                            data = load_json_strings(otaheadinfo)                           
                    if len(args)  == 7:
                             # e.g.  sudo python3 version.py -t ota -i "mcu" "lixell_v1" "mcu/lixel_v1/app" "LIXEL_APP_V1.1.6_20230506.bin" "V1.1.6-mcu" "20230506" "56e3a7f4db73e340a784c9fb863596ae" -f upgrade.json
                            insert_ota_content_info(data, args[0], args[1], args[2], args[3], args[4], args[5], args[6])
                            rewrite_json_file(data, opts.filename)
            elif opts.type == "dev":
                    if os.path.exists(opts.filename):
                            data = load_json_file(opts.filename)
                    else:
                            data = load_json_strings(devverinfo)
                    print(data)
                    if len(args)  == 4:
                        # e.g.  sudo python3 version.py  -t dev -i "SYS" "V1.1.6-mcu" "LIXEL_K1""20230506"  -f Version_sys.json
                        insert_dev_ver_info(data, args[0], args[1], args[2], args[3])
                        rewrite_json_file(data, opts.filename)     
    else:
            print("unsupport options!")

if __name__ == '__main__':
    (options, args) = parserOptions(sys.argv[1:])
    processOptions(options, args)
